/**
 *
 * \file        i2c_eeprom.h
 *
 * \brief       EEPROM class designed to work with the I2C EEPROM
 *              Adapted from TPSB SPI EEPROM code
 *
 *              Supports the following:
 *              Atmel AT24C256
 *              Catalyst CAT24WC256K
 *
 * \author      Adolfo Velasco
 *
 * \date        07/16/08
 *
 */

#ifndef _DM_I2C_EEPROM_H_
#define _DM_I2C_EEPROM_H_

#include "dm_nutypedefs.h"

//EEPROM Configuration table
struct i2c_eeprom_config
{
    UINT8 bInputNum;                        //Input #
    UINT8 bI2CBus;                          //I2C bus the device is on
    UINT8 bI2CAddr;                         //I2C address of the chip
    UINT32 lMaxSize;                        //Maximum EEPROM size (32 * 1024)
    UINT16 sBlockSize;                      //Page size
};

class i2c_eeprom
{
public:

    //Constructor
    i2c_eeprom( const i2c_eeprom_config* pConfig );

    //Block read writes
    UINT8 verify_block( UINT16 sAddr, UINT8* pData, UINT32 lSize );
    UINT8 read_block( UINT16 sAddr, UINT8* pData, UINT32 lSize );
    UINT8 write_block( UINT16 sAddr, UINT8* pData, UINT32 lSize );

private:

    //Wait for device ready
    UINT8 wait_ready( void );

    //Semaphore
    UINT32 m_lLockId;

    //Pointer to configuration table
    const i2c_eeprom_config* m_pConfig;
};

#endif  //_DM_I2C_EEPROM_H_
